/* Contains the functions common to all Phidgets */

#ifdef MACOS //MacOS
#include <Phidget21/Phidget21.h>
#define CCONV
#else //Windows
#include "../../../phidget21.h"
#define CCONV __stdcall
#endif

#ifndef __LCPHIDGET__
#define __LCPHIDGET__

#ifndef __EXTERNAL__
#include <revolution/external.h>
#endif


class Lcphidget{
protected:
	static int CCONV Attach_Handler(CPhidgetHandle ifKit, void *userptr);
	static int CCONV Detach_Handler(CPhidgetHandle ifKit, void *userptr);
	static int CCONV Error_Handler(CPhidgetHandle ifKit, void *userptr, int ErrorCode, const char *unknown);
	
	/* Converts the pointer address of the object to a Phidget handle */
	static CPhidgetInterfaceKitHandle convertToAddr(const char * phid, char ** endptr, int base);
	
	/* Updates r_result, r_pass, and r_err values to allow LiveCode to determine the outcome of the external function. */ 
	static void returnOutcome(int outcome, char **r_result, Bool *r_pass, Bool *r_err);
public:
	
	static void phidgets_set_OnAttach_Handler(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err);
	static void phidgets_set_OnDetach_Handler(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err);
	static void phidgets_set_OnError_Handler(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err);
	static void phidgets_open(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err);
	static void phidgets_close(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err);
	static void phidgets_delete(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err);
	static void phidgets_getDeviceName(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err);
	static void phidgets_getSerialNumber(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err);
	static void phidgets_getDeviceVersion(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err);
	static void phidgets_getDeviceStatus(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err);
	static void phidgets_waitForAttachment(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err);
	static void phidgets_getErrorDescription(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err);
};
#endif